<%@ Page Title="" Language="C#" MasterPageFile="~/Custom/BPR/BPR.Master" AutoEventWireup="true" Inherits="AdminListUsers" Codebehind="AdminListUsers.aspx.cs" %>

<asp:Content ID="Content1" ContentPlaceHolderID="HeadContent" Runat="Server">
</asp:Content>
<asp:Content ID="Content2" ContentPlaceHolderID="MainContent" Runat="Server">

    <script type="text/javascript">

        $(function() {
            if ($('#<%# HiddenFieldClearFlag.ClientID %>').val() === '1')
                $('#<%# TextBoxSearchCriteria.ClientID %>').focus();

        });
    </script>

    <div class="breadcrumb">
        <asp:Label ID="BreadCrumbLabel" runat="server" Text="Administration > Users" />
    </div>
    <div class="excludeSaveWarnings">
        <br />
        <asp:Panel ID="PanelListUsers" runat="server" GroupingText="Manage Users&nbsp;&nbsp;"
            Width="100%">
            <br />
            <table>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelSearchByUserName" runat="server" Text="Search By Username:"
                            AssociatedControlID="TextBoxSearchCriteria" ToolTip="Search by User name" />
                    </td>
                    <td>
                        <asp:TextBox ID="TextBoxSearchCriteria" runat="server" Width="200" ToolTip="Search by User name"></asp:TextBox>
                    </td>
                </tr>
                <tr>
                    <td>
                        <asp:Label SkinID="DataLabel" ID="LabelAccountType" runat="server" Text="Search By Type:"
                            AssociatedControlID="accountTypeDdl" ToolTip="Search by Type" />
                    </td>
                    <td>
                        <asp:DropDownList runat='server' ID='accountTypeDdl' Width='204px' ToolTip='Search by Type'>
                            <asp:ListItem Value='0' Text='All' />
                            <asp:ListItem Value='1' Text='Active' />
                            <asp:ListItem Value='2' Text='Inactive' />
                            <asp:ListItem Value='3' Text='Pending' />
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td>
                    </td>
                    <td>
                        <asp:Button ID="ButtonSearch" runat="server" Text=" Search " OnClick="OKButton_Click" />
                    </td>
                </tr>
            </table>
            <asp:HiddenField ID="HiddenFieldClearFlag" runat="server" />
            <br />
            <asp:Panel runat='server' ID='searchResultsPnl' Visible='false' Width='800px'>
                <div style='text-align: right; width: 800px;' runat='server' id='pageSizeDiv'>
                    <asp:Label SkinID="DataLabel" ID="LabelItemsPerPage" runat="server" Text="Items Per Page"
                            AssociatedControlID="gridViewPageSizeDdl" ToolTip="Items per page" />
                    
                    <asp:DropDownList runat='server' ID='gridViewPageSizeDdl' AutoPostBack='true' CausesValidation='false' ToolTip="Items per page"
                        OnSelectedIndexChanged='gridViewPageSizeDdlChanged'>
                        <asp:ListItem Text='10' Value='10'></asp:ListItem>
                        <asp:ListItem Text='25' Value='25'></asp:ListItem>
                        <asp:ListItem Text='50' Value='50'></asp:ListItem>
                        <asp:ListItem Text='100' Value='100'></asp:ListItem>
                    </asp:DropDownList>
                </div>
                <asp:GridView ID="GridViewUsers" runat="server" DataKeyNames="UserId" AutoGenerateColumns="False"
                    AllowPaging="True" Caption="To sort please click table headings" AllowSorting="True"
                    EmptyDataText="No Users Found." ShowFooter="true" PageSize="10" PagerSettings-Mode="Numeric"
                    OnRowCommand="GridViewUsers_RowCommand" OnRowDataBound='GridViewUsers_RowDataBound'
                    OnSorting='MyPMebsGridView_Sorting' OnPageIndexChanging='MyPMebsGridView_PageIndexChanging'>
                    <EmptyDataTemplate>
                        &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp
                        No Users Found. &nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp&nbsp</EmptyDataTemplate>
                    <Columns>
                        <asp:HyperLinkField DataNavigateUrlFields="UserId" SortExpression="UserId" NavigateUrl="~/AdminEditUsersRoles.aspx"
                            ItemStyle-HorizontalAlign="Center" HeaderStyle-HorizontalAlign="Center" DataNavigateUrlFormatString="AdminEditUsers.aspx?id={0}"
                            DataTextField="UserId" HeaderText="Id">
                            <HeaderStyle HorizontalAlign="Center"></HeaderStyle>
                            <ItemStyle HorizontalAlign="Center" Width="18px"></ItemStyle>
                        </asp:HyperLinkField>
                        <asp:TemplateField HeaderText="Username" SortExpression="Username">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle Width="150px"></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelUserName" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Username")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Name" SortExpression="Name">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle Width="250px"></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelFullName" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("Name")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Last Login" SortExpression="LastLogin">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle Width="250px"></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelLastLogin" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("LastLogin")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Last Vista Login" SortExpression="LastVistaLogin">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemStyle Width="250px"></ItemStyle>
                            <ItemTemplate>
                                <asp:Label ID="LabelLastVistaLogin" runat="server" SkinID="DataLabel" Text='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("LastVistaLogin")) %>'></asp:Label>
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Roles" SortExpression="" AccessibleHeaderText="Edit Roles">
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton runat='server' ID='editRolesBtn' CommandName='Edit Roles' Text='Roles'
                                    CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("UserId")) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="Action" SortExpression="" AccessibleHeaderText='Activate'>
                            <ItemStyle HorizontalAlign="Left" />
                            <HeaderStyle HorizontalAlign="Center" />
                            <ItemTemplate>
                                <asp:LinkButton runat='server' ID='activateBtn' CommandName='Activate' CommandArgument='<%# VIRP_WEB.BaseCode.Helpers.AntiXssEval(Eval("UserId")) %>' />
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                    <FooterStyle HorizontalAlign='Right' BackColor='White' />
                </asp:GridView>
                <div>
                    <p style='color: DarkGreen'>
                        Active Users</p>
                    <p style='color: #996600'>
                        Pending Users</p>
                    <p style='color: Red'>
                        Inactive Users</p>
                </div>
            </asp:Panel>
            <br />
            <asp:Button ID="ButtonAddUser" runat="server" Text="  Add User  " PostBackUrl="~/AdminEditUsers.aspx" />
            <asp:HiddenField ID="HiddenFieldRegistryName" runat="server" />
        </asp:Panel>
    </div>
</asp:Content>
